static char prog_copyright[] = "Copyright 1993 Digital Equipment Corp. xxxxxx";

#ident	"@(#)kit:eth/src/lmac.cf/Space.c	1.0"
#ident  "$Header: $"

#include <sys/types.h>
#include <sys/stream.h>
#include <sys/dlpi_ether.h>
#include <config.h>

/*
 *  The N_SAPS define determines how many protocol drivers can bind to a single
 *  LMAC  board.  A TCP/IP environment requires a minimum of two (IP and ARP).
 *  Putting an excessively large value here would waste memory.  A value that
 *  is too small could prevent a system from supporting a desired protocol.
 */
#define	N_SAPS		8

/*
 * The next three configurable parameters (CABLE_TYPE, SAAD, ZWS) will only be
 * used when there's 1 board configured on the system. Since there's only one
 * port (port 0x100) to configure the board, multiple boards can't be configured
 * through the same port. To configure multiple boards, read the EthereLink 16
 * Installation and Configuration Guide and make sure the same parameters are
 * set in the Unix systems configuration file.
 */

/*
 *  The CABLE_TYPE define determines the ethernet cable type.  A value of 1
 *  indicates the ethernet controller is to be attached to thick ethernet
 *  cable (AUI).  A value of 0 indicates a thin ethernet cable (BNC).
 */
#define	CABLE_TYPE	1

/*
 * The ZWS (Zero Wait State) define determines the wait state of the RAM.
 * A value of 0 disables 0WS. A value of 1 enable 0WS.
 */
#define ZWS 0

/*
 * The SAAD define determines the SA address decode. A value of 0 allows
 * SA address decode (normal operation). A value of 1 disables SA address
 * decode.
 */
#define SAAD 0

/*
 *  The STREAMS_LOG define determines if STREAMS tracing will be done in the
 *  driver.  A non-zero value will allow the strace(1M) command to follow
 *  activity in the driver.  The driver ID used in the strace(1M) command is
 *  equal to the ENET_ID value (generally 2101).
 *
 *  NOTE:  STREAMS tracing can greatly reduce the performance of the driver
 *         and should only be used for trouble shooting.
 */
#define	STREAMS_LOG	0

/*
 *  The IFNAME define determines the name of the the internet statistics
 *  structure for this driver and only has meaning if the inet package is
 *  installed.  It should match the interface prefix specified in the strcf(4)
 *  file and ifconfig(1M) command used in rc.inet.  The unit number of the
 *  interface will match the board number (i.e emd0, emd1, emd2) and is not
 *  defined here.
 */
#define	IFNAME	"lmac"

/********************** STOP!  DON'T TOUCH THAT DIAL ************************
 *
 *  The following values are set by the kernel build utilities and should not
 *  be modified by mere motals.
 */
int		lmaccable_type	= CABLE_TYPE;
int		lmaczws 	= ZWS;
int		lmacsaad 	= SAAD;
int		lmacboards 	= LMAC_CNTLS;
int		lmacstrlog 	= STREAMS_LOG;
char		*lmac_ifname 	= IFNAME;

DL_sap_t	lmacsaps[ N_SAPS * LMAC_CNTLS ];

DL_bdconfig_t	lmacconfig[ LMAC_CNTLS ] = {
#ifdef LMAC_0
	{
		LMAC_CMAJOR_0,		/* Major number			*/
		LMAC_0_SIOA,		/* Start of base I/O address	*/
		LMAC_0_EIOA,		/* End of base I/O address	*/
		LMAC_0_SCMA,		/* Start of base memory address	*/
		LMAC_0_ECMA,		/* End of base memory address	*/
		LMAC_0_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef LMAC_1
	{
		LMAC_CMAJOR_1,		/* Major number			*/
		LMAC_1_SIOA,		/* Start of base I/O address	*/
		LMAC_1_EIOA,		/* End of base I/O address	*/
		LMAC_1_SCMA,		/* Start of base memory address	*/
		LMAC_1_ECMA,		/* End of base memory address	*/
		LMAC_1_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef LMAC_2
	{
		LMAC_CMAJOR_2,		/* Major number			*/
		LMAC_2_SIOA,		/* Start of base I/O address	*/
		LMAC_2_EIOA,		/* End of base I/O address	*/
		LMAC_2_SCMA,		/* Start of base memory address	*/
		LMAC_2_ECMA,		/* End of base memory address	*/
		LMAC_2_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
#ifdef LMAC_3
	{
		LMAC_CMAJOR_3,		/* Major number			*/
		LMAC_3_SIOA,		/* Start of base I/O address	*/
		LMAC_3_EIOA,		/* End of base I/O address	*/
		LMAC_3_SCMA,		/* Start of base memory address	*/
		LMAC_3_ECMA,		/* End of base memory address	*/
		LMAC_3_VECT,		/* Interrupt vector number	*/
		N_SAPS,
		0,
	},
#endif
};

/*
 *  If there are multiple LMAC boards in the same system, make sure there is
 *  a comma separated value for each one.
 */
int	lmac_cable_type[ LMAC_CNTLS ] = {
#ifdef LMAC_0
		CABLE_TYPE,
#endif
#ifdef LMAC_1
		CABLE_TYPE,
#endif
#ifdef LMAC_2
		CABLE_TYPE,
#endif
#ifdef LMAC_3
		CABLE_TYPE,
#endif
};

#ifdef IP
int	lmacinetstats = 1;
#else
int	lmacinetstats = 0;
#endif
